import { storiesOf } from '@storybook/react';
import React from 'react';

import StatisticsInput from '../statisticsInput';

const stubAction = () => ({});

storiesOf('StatisticsInput', module)
    .add('plain', () => (
        <StatisticsInput
            buttonText="Скачать отчёт"
            onSubmit={stubAction}
            typeAction={stubAction}
            focus={stubAction}
            blur={stubAction}
            />
    ))
    .add('Ввод текста', () => (
        <StatisticsInput
            buttonText="Скачать отчёт"
            inputText="текст"
            onSubmit={stubAction}
            typeAction={stubAction}
            focus={stubAction}
            blur={stubAction}
            />
    ))
    .add('С подсказкой', () => (
        <StatisticsInput
            buttonText="Скачать отчёт"
            tip="Подсказка"
            inputText="текст"
            onSubmit={stubAction}
            typeAction={stubAction}
            focus={stubAction}
            blur={stubAction}
            />
    ))
    .add('placeholder', () => (
        <StatisticsInput
            buttonText="Скачать отчёт"
            placeholder="Логин"
            onSubmit={stubAction}
            typeAction={stubAction}
            focus={stubAction}
            blur={stubAction}
            />
    ))
    .add('Валидация', () => (
        <StatisticsInput
            buttonText="Скачать отчёт"
            errorMessage="Ошибка"
            onSubmit={stubAction}
            typeAction={stubAction}
            focus={stubAction}
            blur={stubAction}
            />
    ));
