import React from 'react';

import { TextArea } from 'lego-on-react';
import { cn } from '@bem-react/classname';

import './statisticsLogins.css';
import 'lego-on-react/src/components/textarea/textarea.css';

const b = cn('StatisticsLogins');

interface IStatisticsLoginsProps {
    tip?: string,
    value?: string,
    inputId?: number,
    handleChange(value: string | string[]): void
}

const StatisticsLogins = (props: IStatisticsLoginsProps) => {
    const {
        tip,
        value = '',
        inputId = 1,
        handleChange
    } = props;

    const inputIdString = inputId.toString();

    return (
        <div className={b()}>
            { tip && (<label className={b('Tip')} htmlFor={inputIdString}>{tip}</label>) }
            <TextArea
                id={inputIdString}
                theme="normal"
                size="m"
                rows={5}
                text={value}
                onChange={handleChange}
                />
        </div>
    );
};

export default StatisticsLogins;
