import React from 'react';

import { Select } from 'lego-on-react';

import Dictionary from '../../../common/types/dictionary';

import 'lego-on-react/src/components/select/select.css';

type SelectType = 'radio' | 'check' | 'radiocheck';
type SelectWidth = 'fixed' | 'max';

interface IStatisticsSelectProps {
    tip?: string,
    items?: Dictionary<string>,
    value?: string | string[],
    type?: SelectType,
    width?: SelectWidth,
    handleChange(value: string | string[]): void
}

const StatisticsSelect = (props: IStatisticsSelectProps) => {
    const {
        tip,
        items = {},
        value = '',
        type = 'radio',
        handleChange,
        width = 'fixed'
    } = props;

    return (
        <Select
            theme="normal"
            size="m"
            type={type}
            text="vary"
            width={width}
            name={tip}
            placeholder={tip}
            val={value}
            onChange={handleChange}
            >
            {Object.keys(items)
                .map((key: string) => {
                    const label = items[key];

                    return (
                        <Select.Item key={key} val={key}>
                            {label}
                        </Select.Item>
                    );
                })
            }
        </Select>
    );
};

export default StatisticsSelect;
