import React, { Component } from 'react';
import { cn } from '@bem-react/classname';

import './tab.css';

import { RouteComponentProps } from 'react-router';
import { History } from 'history';

const b = cn('Tab');

interface IOwnProps {
    name: string,
    text: string,
    isActive: boolean,
    onClick(name: string, history: History): void
}

type TabProps = IOwnProps & RouteComponentProps<{}>;

class Tab extends Component<TabProps> {
    private onClick = () => {
        const { name, history, onClick } = this.props;

        return onClick(name, history);
    };

    render() {
        const { text, isActive } = this.props;
        const tabClass = b({ active: isActive });

        return (
            <div className={tabClass} onClick={this.onClick}>{text}</div>
        );
    }
}

export default Tab;
