import { ReactNode } from 'react';
import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';
import { History } from 'history';

import { ApplicationState } from 'client/store';
import { TabsAction } from 'client/store/tabs/types';
import { selectActive } from 'client/store/tabs/actions';

import Tabs from './tabs';

export interface ITabItem {
    name: string,
    text: string,
    content: ReactNode
}

interface IOwnProps {
    items: ITabItem[],
    initialActiveTab: string
}

export interface IStateProps {
    activeTabName: string
}

type TabsProps = IOwnProps & IStateProps;

interface IDispatchProps {
    selectActive(name: string, history: History): void
}

function mapStateToProps(
    state: ApplicationState, ownProps: IOwnProps
): TabsProps {
    const { activeTabName } = state.tabs;
    const { initialActiveTab, items } = ownProps;

    return {
        activeTabName: activeTabName || initialActiveTab,
        initialActiveTab,
        items
    };
}

function mapDispatchToProps(dispatch: Dispatch<TabsAction>): IDispatchProps {
    return bindActionCreators({
        selectActive
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(Tabs);
