import React, { Component } from 'react';
import { cn } from '@bem-react/classname';

import Tab from 'client/components/tab';

import { ITabItem } from 'client/components/tabs';
import { History } from 'history';

import './tabs.css';

const b = cn('Tabs');

interface ITabsProps {
    activeTabName: string,
    items: ITabItem[],
    selectActive(name: string, history: History): void
}

class Tabs extends Component<ITabsProps> {
    public render() {
        const { items, activeTabName, selectActive } = this.props;
        const activeTab = items.find(item => item.name === activeTabName);

        return (
            <div className={b()}>
                <div className={b('Menu')}>
                    {items.map(item => {
                        const { name, text } = item;
                        const isActive = activeTabName === name;

                        return (
                            <Tab
                                key={name}
                                name={name}
                                text={text}
                                isActive={isActive}
                                onClick={selectActive}
                                />
                        );
                    })}
                </div>
                <div className={b('Content')}>
                    {activeTab!.content}
                </div>
            </div>
        );
    }
}

export default Tabs;
