import { cn } from '@bem-react/classname';
import { classnames } from '@bem-react/classnames';
import React, { Component } from 'react';
import { Link } from 'lego-on-react';

import { IProctoringResponsesInfo, ITolokaAnswer } from 'client/store/videos/types';

import './tolokaInfo.css';
import 'client/components/table/table.css';
import 'lego-on-react/src/components/link/link.css';

const b = cn('TolokaInfo');

interface ITolokaInfoProps {
    tolokaInfo: IProctoringResponsesInfo[]
}

interface ITolokaInfoState {
    isExpanded: boolean
}

interface IRowParams {
    answer: ITolokaAnswer,
    source: string,
    start: number,
    end: number
}

class TolokaInfo extends Component<ITolokaInfoProps, ITolokaInfoState> {
    constructor(props: ITolokaInfoProps) {
        super(props);

        this.state = { isExpanded: false };
    }

    private readonly toggleExpand = () => {
        const { isExpanded } = this.state;

        this.setState({ isExpanded: !isExpanded });
    };

    private readonly boolToWord = (value: boolean) => {
        return value ? 'Да' : 'Нет';
    };

    private readonly getRow = (rowParams: IRowParams) => {
        const { answer, source, start, end } = rowParams;
        const {
            violations,
            noVioAudioProblems,
            noVioNoRelate,
            noVioOther,
            noVioOtherText,
            noVioVideoProblems,
            vioCheating,
            vioDiffUser,
            vioOther,
            vioOtherPeople,
            vioOtherText,
            vioTips,
            vioWalkAwayScreen
        } = answer;

        const stickyClass = b('TableCell', { sticky: true });

        return (
            <tr>
                <td className={stickyClass}>{source}</td>
                <td className={stickyClass}>{start}</td>
                <td className={stickyClass}>{end}</td>
                <td>{this.boolToWord(violations)}</td>
                <td>{this.boolToWord(noVioAudioProblems)}</td>
                <td>{this.boolToWord(noVioVideoProblems)}</td>
                <td>{this.boolToWord(noVioNoRelate)}</td>
                <td>{this.boolToWord(noVioOther)}</td>
                <td>{noVioOtherText}</td>
                <td>{this.boolToWord(vioDiffUser)}</td>
                <td>{this.boolToWord(vioWalkAwayScreen)}</td>
                <td>{this.boolToWord(vioOtherPeople)}</td>
                <td>{this.boolToWord(vioTips)}</td>
                <td>{this.boolToWord(vioCheating)}</td>
                <td>{this.boolToWord(vioOther)}</td>
                <td>{vioOtherText}</td>
            </tr>
        );
    };

    private readonly renderData = () => {
        const { tolokaInfo } = this.props;

        return tolokaInfo.reduce((res, info) => {
            const { source, additionalInfo } = info;

            const additionalRender = additionalInfo.reduce((infoBySource, addInfo) => {
                const { start, end, answers } = addInfo;

                const rows = answers.map(answer => {
                    return this.getRow({ answer, source, start, end });
                });

                return [...infoBySource, ...rows] as Element[];
            }, [] as Element[]);

            return [...res, ...additionalRender] as Element[];
        }, [] as Element[]);
    };

    public render() {
        const { isExpanded } = this.state;
        const stickyClass = b('TableCell', { sticky: true });

        return (
            <div className={b({ expanded: isExpanded })}>
                <div className={b('Header')}>
                    <Link
                        theme="pseudo"
                        pseudo
                        text="Вердикты Толокеров"
                        cls={b('Title')}
                        onClick={this.toggleExpand}
                        />
                </div>
                <div className={b('TableWrapper')}>
                    <table className={classnames(b('Verdicts'), cn('Table')())}>
                        <thead>
                            <tr>
                                <th className={stickyClass}>Источник вердикта</th>
                                <th className={stickyClass}>Начало интервала (сек)</th>
                                <th className={stickyClass}>Конец интервала (сек)</th>
                                <th>Нарушения</th>
                                <th>Технические помехи аудио</th>
                                <th>Технические помехи видео</th>
                                <th>Помехи бытового характера</th>
                                <th>Нет нарушений: другое</th>
                                <th>Нет нарушений: другое (текст)</th>
                                <th>Разные пользователи на фото и видео</th>
                                <th>Пользователь отошел от экрана</th>
                                <th>Присутствуют другие люди за спиной</th>
                                <th>Слышно диктовку или подсказки</th>
                                <th>Признаки списывания</th>
                                <th>Есть нарушения: другое</th>
                                <th>Есть нарушения: другое (текст)</th>
                            </tr>
                        </thead>
                        <tbody>
                            { this.renderData() }
                        </tbody>
                    </table>
                </div>
            </div>
        );
    }
}

export default TolokaInfo;
