import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from '../../store';

import { TrialsByPeriodAction } from '../../store/trialsByPeriod/types';

import { PeriodDateType } from '../../store/common/types';
import Dictionary from '../../../common/types/dictionary';

import {
    changeFromDate,
    changeToDate,
    chooseExams,
    changeLogins
} from '../../store/trialsByPeriod/actions';

import TrialsByPeriod from './trialsByPeriod';

interface IStateProps {
    from?: Date,
    to?: Date,
    error?: PeriodDateType,
    exams?: string[],
    logins?: string
}

interface IOwnProps {
    urlTemplate: string,
    examSlugs?: Dictionary<string>
}

type TrialsByPeriodProps = IStateProps & IOwnProps;

interface IDispatchProps {
    changeFromDate(date: Date): void,
    changeToDate(date: Date): void,
    chooseExams(exams: string[]): void,
    changeLogins(logins: string): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): TrialsByPeriodProps {
    const {
        from,
        to,
        error,
        exams,
        logins
    } = state.trialsByPeriod;
    const { urlTemplate, examSlugs } = ownProps;

    return {
        from,
        to,
        error,
        exams,
        urlTemplate,
        examSlugs,
        logins
    };
}

function mapDispatchToProps(dispatch: Dispatch<TrialsByPeriodAction>): IDispatchProps {
    return bindActionCreators({
        changeFromDate,
        changeToDate,
        chooseExams,
        changeLogins
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps, IOwnProps>(
    mapStateToProps,
    mapDispatchToProps
)(TrialsByPeriod);
