import { cn } from '@bem-react/classname';
import React, { Component } from 'react';
import { stringify } from 'query-string';

import { Button } from 'lego-on-react';

import Dictionary from '../../../common/types/dictionary';

import { PeriodDateType } from '../../store/common/types';

import 'lego-on-react/src/components/button/button.css';
import 'lego-on-react/src/components/textarea/textarea.css';

import './trialsByPeriod.css';

import StatisticsDate from '../statisticsDate';
import StatisticsSelect from '../statisticsSelect';
import StatisticsContainer from '../statisticsContainer/statisticsContainer';
import StatisticsLogins from '../statisticsLogins/statisticsLogins';

interface ITrialsByPeriodProps {
    urlTemplate: string,
    examSlugs?: Dictionary<string>,
    from?: Date,
    to?: Date,
    error?: PeriodDateType,
    exams?: string[],
    logins?: string,
    changeFromDate(date: Date): void,
    changeToDate(date: Date): void,
    chooseExams(exams: string[]): void,
    changeLogins(logins: string): void
}

const b = cn('TrialsByPeriod');

class TrialsByPeriod extends Component<ITrialsByPeriodProps> {
    public render() {
        const {
            from,
            to,
            error,
            exams,
            examSlugs,
            logins,
            changeFromDate,
            changeToDate,
            chooseExams,
            changeLogins
        } = this.props;

        return (
            <div className={b()}>
                <StatisticsContainer title="Получение данных о попытках за указанный период">
                    <div className={b('Date')}>
                        <StatisticsDate
                            from={from}
                            to={to}
                            error={error}
                            changeFromDate={changeFromDate}
                            changeToDate={changeToDate}
                            />
                    </div>
                    <div className={b('Select')}>
                        <StatisticsSelect
                            tip="Тестирование"
                            items={examSlugs}
                            type="radio"
                            value={exams}
                            handleChange={chooseExams}
                            />
                    </div>
                    <div className={b('Logins')}>
                        <StatisticsLogins
                            tip="Список логинов пользователей (опционально, через пробел)"
                            value={logins}
                            handleChange={changeLogins}
                            />
                    </div>
                    <div className={b('Button')}>
                        <Button
                            theme="action"
                            size="m"
                            text="Скачать отчёт"
                            disabled={this._isDisabled}
                            onClick={this._onSubmit}
                            />
                    </div>
                </StatisticsContainer>
            </div>
        );
    }

    private get _isDisabled() {
        const { from, to, exams } = this.props;

        return !from || !to || !exams || exams.length === 0;
    }

    private readonly _getQuery = () => {
        const { from, to, exams, logins } = this.props;

        return stringify({
            from: from && from.toISOString(),
            to: to && to.toISOString(),
            slug: exams,
            login: logins && logins.split(/\s+/)
        });
    }

    private readonly _onSubmit = () => {
        const { urlTemplate } = this.props;

        if (this._isDisabled) {
            return;
        }

        const query = this._getQuery();

        if (window) {
            window.location.href = `${urlTemplate}&${query}`;
        }
    };

}

export default TrialsByPeriod;
