import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from 'client/store/index';
import Dictionary from 'common/types/dictionary';
import { IDetailsError } from 'common/utils/error';

import { IGlobalUserInfo } from 'client/store/bans/types';

import { UnbanFormAction, IUnbanPayload } from 'client/store/unbanForm/types';

import {
    chooseExams,
    typeLogin,
    typeReason,
    toggleSuperUnban,
    pressUnban,
    decline,
    unban
} from 'client/store/unbanForm/actions';

import { getBanInfo } from 'client/store/bans/actions';

import RequestStatus from 'common/types/requestStatus';

import UnbanForm from './unbanForm';

interface IOwnProps {
    examsById: Dictionary<string>,
    globalUserInfo: IGlobalUserInfo,
    bannedExamsIds: string[]
}

interface IStateProps {
    examsForUnban: string[],
    userLogin: string,
    banLogin: string,
    unbanStatus: RequestStatus | null,
    requestError: IDetailsError | null,
    isSuperUnban: boolean,
    reason: string,
    isVisibleConfirmationModal: boolean,
    submitErrors: string[] | null
}

type UnbanFormProps = IStateProps & IOwnProps;

interface IDispatchProps {
    chooseExams(exams: string[]): void,
    typeLogin(inputText: string): void,
    typeReason(inputText: string): void,
    toggleSuperUnban(): void,
    pressUnban(): void,
    decline(): void,
    unban(unbanData: IUnbanPayload): void,
    getBanInfo(login: string): void
}

function mapStateToProps(state: ApplicationState, ownProps: IOwnProps): UnbanFormProps {
    const {
        examsForUnban,
        unbanStatus,
        requestError,
        submitErrors,
        reason,
        isSuperUnban,
        isVisibleConfirmationModal,
        userLogin
    } = state.unbanForm;

    const { login: banLogin } = state.bans;

    const { examsById, globalUserInfo, bannedExamsIds } = ownProps;

    return {
        examsById,
        globalUserInfo,
        examsForUnban,
        userLogin,
        banLogin,
        unbanStatus,
        requestError,
        submitErrors,
        isSuperUnban,
        reason,
        isVisibleConfirmationModal,
        bannedExamsIds
    };
}

function mapDispatchToProps(dispatch: Dispatch<UnbanFormAction>): IDispatchProps {
    return bindActionCreators({
        chooseExams,
        typeLogin,
        typeReason,
        toggleSuperUnban,
        unban,
        pressUnban,
        decline,
        getBanInfo
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps>(
    mapStateToProps,
    mapDispatchToProps
)(UnbanForm);
