import { cn } from '@bem-react/classname';
import React, { Component, createRef } from 'react';
import { Player } from 'video-react';
import { Select } from 'lego-on-react';

import './video.css';
import 'node_modules/video-react/dist/video-react.css';
import 'lego-on-react/src/components/select/select.css';

interface IVideoProps {
    src: string
}

const b = cn('Video');

class Video extends Component<IVideoProps> {
    private readonly playerRef = createRef<HTMLVideoElement>();

    private readonly changeVideoSpeed = (value: string[]) => {
        this.playerRef.current!.playbackRate = Number(value[0]);
    };

    public render() {
        const { src } = this.props;

        return (
            <div className={b()}>
                <Player
                    playsInline
                    src={src}
                    ref={this.playerRef}
                    />
                <Select
                    theme="normal"
                    type="radio"
                    size="s"
                    view="default"
                    text="vary"
                    width="max"
                    placeholder="Ускорить"
                    val="1"
                    tone="default"
                    onChange={this.changeVideoSpeed}
                    cls={b('Select')}
                    items={[
                        { val: '1', text: 'x1' },
                        { val: '2', text: 'x2' },
                        { val: '4', text: 'x4' },
                        { val: '8', text: 'x8' },
                        { val: '16', text: 'x16' }
                    ]}
                    />
            </div>
        );
    }
}

export default Video;
