import { bindActionCreators, Dispatch } from 'redux';
import { connect } from 'react-redux';

import { ApplicationState } from '../../store/index';
import RequestStatus from '../../../common/types/requestStatus';

import {
    VideosAction,
    VerdictType,
    IVideosError,
    IAppealDataFromDB,
    IProctoringResponsesInfo
} from '../../store/videos/types';

import {
    typeAttemptIdAction,
    focusAttemptId,
    blurAttemptId,
    getVideos,
    decide,
    typeEmailAction,
    focusEmail,
    blurEmail,
    showConfirmation,
    confirm,
    decline
} from '../../store/videos/actions';

import Videos from './videos';

interface IStateProps {
    attemptId: string,
    hasFocusAttemptId: boolean,
    isValidAttemptId: boolean,
    hasAttemptId: boolean,
    videos: string[],
    verdict: VerdictType,
    email: string,
    hasFocusEmail: boolean,
    isValidEmail: boolean,
    isSubmitError: boolean,
    hasEmail: boolean,
    requestStatus: RequestStatus | null,
    requestError: IVideosError | null,
    isVisibleConfirmationModal: boolean,
    isAppealSuccess: boolean,
    appealDataFromDB: IAppealDataFromDB | null,
    pdfLink: string,
    proctoringResponsesInfo: IProctoringResponsesInfo[] | null
}

interface IDispatchProps {
    typeAttemptIdAction(inputText: string): void,
    focusAttemptId(): void,
    blurAttemptId(): void,
    getVideos(attemptId: string, url: string): void,
    decide(verdict: VerdictType): void,
    typeEmailAction(inputText: string): void,
    focusEmail(): void,
    blurEmail(): void,
    showConfirmation(): void,
    confirm(attemptId: string, verdict: VerdictType, email: string, url: string): void,
    decline(): void
}

function mapStateToProps(state: ApplicationState): IStateProps {
    const {
        attemptId,
        hasFocusAttemptId,
        isValidAttemptId,
        hasAttemptId,
        videos,
        verdict,
        email,
        hasFocusEmail,
        isValidEmail,
        isSubmitError,
        hasEmail,
        requestStatus,
        requestError,
        isVisibleConfirmationModal,
        isAppealSuccess,
        appealDataFromDB,
        pdfLink,
        proctoringResponsesInfo
    } = state.videos;

    return {
        attemptId,
        hasFocusAttemptId,
        isValidAttemptId,
        hasAttemptId,
        videos,
        verdict,
        email,
        hasFocusEmail,
        isValidEmail,
        isSubmitError,
        hasEmail,
        requestStatus,
        requestError,
        isVisibleConfirmationModal,
        isAppealSuccess,
        appealDataFromDB,
        pdfLink,
        proctoringResponsesInfo
    };
}

function mapDispatchToProps(dispatch: Dispatch<VideosAction>): IDispatchProps {
    return bindActionCreators({
        typeAttemptIdAction,
        focusAttemptId,
        blurAttemptId,
        getVideos,
        decide,
        typeEmailAction,
        focusEmail,
        blurEmail,
        showConfirmation,
        confirm,
        decline
    }, dispatch);
}

export default connect<IStateProps, IDispatchProps>(
    mapStateToProps,
    mapDispatchToProps
)(Videos);
