import React, { Component, ComponentType } from 'react';

interface IInputIdProps {
    inputId?: number
}

let incrementKey = 1;

interface IIncrementKeyState {
    incrementKey: number
}

export default function withIncrementKey<T>(WrappedComponent: ComponentType<T & IInputIdProps>) {
    return class Wrapper extends Component<T, IIncrementKeyState> {
        public constructor(props: T) {
            super(props);

            this.state = { incrementKey };

            incrementKey += 1;
        }

        public render() {
            return (
                <WrappedComponent {...this.props} inputId={this.state.incrementKey} />
            );
        }
    };
}
