import React, { Component, ComponentType } from 'react';
import { stringify } from 'query-string';
import { Omit } from 'utility-types';

interface IQueryData {
    queryParam: string
}

interface IOwnProps {
    inputText: string,
}

interface IHighOrderProps {
    onSubmit(): void
}

interface IUrlData {
    urlTemplate: string
}

type StatisticsProps = IOwnProps & IHighOrderProps;

export default function withStatistics<T extends StatisticsProps>(data: IQueryData) {
    return (WrappedComponent: ComponentType<T>) => {
        return class Wrapper extends Component<Omit<T, keyof IHighOrderProps> & IUrlData> {
            public render() {
                return <WrappedComponent {...this.props} onSubmit={this._onSubmit} />;
            }

            private readonly _onSubmit = () => {
                const { inputText, urlTemplate } = this.props;

                const query = stringify({ [data.queryParam]: inputText });

                if (window && inputText) {
                    window.location.href = `${urlTemplate}&${query}`;
                }
            };
        };
    };
}
