import React, { Component, Fragment } from 'react';
import Helmet from 'react-helmet';

import Layout from '../../components/layout';
import Tests from '../../components/tests';

interface IAdminPageProps {
    data: any
}

export default class AdminPage extends Component<IAdminPageProps> {
    render() {
        const { data } = this.props;

        return (
            <Fragment>
                <Helmet>
                    <title>Сертификация – Панель администрирования</title>
                </Helmet>
                <Layout type="Fullpage">
                    <Tests
                        exams={data.base.exams}
                        api={data.base.api}
                        lockedExams={data.adminData.lockedExams}
                        />
                </Layout>
            </Fragment>
        );
    }
}
