import React, { Component, Fragment } from 'react';
import Helmet from 'react-helmet';

import Layout from 'client/components/layout';
import Ban from 'client/components/ban';

interface IBanPageProps {
    data: any
}

export default class BanPage extends Component<IBanPageProps> {
    render() {
        const { data } = this.props;

        return (
            <Fragment>
                <Helmet>
                    <title>Сертификация – Бан пользователей</title>
                </Helmet>
                <Layout type="Fullpage">
                    <Ban exams={data.base.exams} examsById={data.examsById} />
                </Layout>
            </Fragment>
        );
    }
}
