import React, { Component, Fragment } from 'react';
import Helmet from 'react-helmet';

import Layout from '../../components/layout';
import Freezing from '../../components/freezing';

interface IDevPageProps {
    data: any
}

export default class DevPage extends Component<IDevPageProps> {
    render() {
        const { data } = this.props;
        const { examsById } = data;

        return (
            <Fragment>
                <Helmet>
                    <title>Сертификация – Панель администрирования</title>
                </Helmet>
                <Layout>
                    <Freezing examsById={examsById} />
                </Layout>
            </Fragment>
        );
    }
}
