import React, { Component, Fragment } from 'react';
import Helmet from 'react-helmet';

import Layout from '../../components/layout';
import EditExam from '../../components/editExam';

interface IExamPageProps {
    data: any
}

export default class ExamPage extends Component<IExamPageProps> {
    render() {
        const { data: {
            exam,
            adminData: { userRoles, lockedExams },
            base: { userInfo: { login } }
        } } = this.props;
        const pageTitle = `Сертификация – Панель администрирования – ${exam.slug}`;
        const isLocked = lockedExams[exam.slug] && lockedExams[exam.slug].login !== login;

        return (
            <Fragment>
                <Helmet>
                    <title>{pageTitle}</title>
                </Helmet>
                <Layout type="Fullpage">
                    <EditExam
                        exam={exam}
                        userRoles={userRoles}
                        isLocked={isLocked}
                        />
                </Layout>
            </Fragment>
        );
    }
}
