import React, { Component, Fragment } from 'react';
import Helmet from 'react-helmet';

import Layout from '../../components/layout';
import Reports from '../../components/reports';

import Dictionary from '../../../common/types/dictionary';
import { AdminData } from '../../../common/types/adminData';

interface IIndexPageProps {
    data: {
        reportsUrls: Dictionary<string>,
        reportTypes: string[],
        examSlugs: Dictionary<string>,
        intervals: Dictionary<string>,
        agenciesStatUrl: string,
        adminData: AdminData
    }
}

export default class IndexPage extends Component<IIndexPageProps> {
    render() {
        const {
            reportsUrls,
            reportTypes,
            examSlugs,
            intervals,
            agenciesStatUrl,
            adminData: {
                userRoles,
                lastSyncAgenciesDate
            }
        } = this.props.data;

        return (
            <Fragment>
                <Helmet>
                    <title>Сертификация – Панель администрирования</title>
                </Helmet>
                <Layout>
                    <Reports
                        reportsUrls={reportsUrls}
                        reportTypes={reportTypes}
                        examSlugs={examSlugs}
                        intervals={intervals}
                        agenciesStatUrl={agenciesStatUrl}
                        userRoles={userRoles}
                        lastSyncAgenciesDate={lastSyncAgenciesDate}
                        />
                </Layout>
            </Fragment>
        );
    }
}
