import { handleActions } from 'redux-actions';

import {
    ActionTypes,
    AgenciesStatPayload
} from './types';

export interface IAgenciesStatState {
    isRequestedUpdate: boolean,
    isError: boolean
}

const initialState: IAgenciesStatState = {
    isRequestedUpdate: false,
    isError: false
};

function update(state: IAgenciesStatState): IAgenciesStatState {
    return {
        ...state,
        isRequestedUpdate: true,
        isError: false
    };
}

function agenciesStatError(state: IAgenciesStatState): IAgenciesStatState {
    return {
        ...state,
        isError: true
    };
}

export default handleActions<IAgenciesStatState, AgenciesStatPayload>({
    [ActionTypes.UPDATE]: update,
    [ActionTypes.AGENCIES_STAT_ERROR]: agenciesStatError
}, initialState);
