import { all, call, takeLatest, put } from 'redux-saga/effects';

import { serverUrls } from '../../../common/server-urls';

import fetch from '../../common/fetch';

import { ActionTypes } from './types';
import { updateStat, agenciesStatError } from './actions';

function *update() {
    try {
        const url = serverUrls.syncAgenciesInfo.build();

        yield call(fetch, url, {
            method: 'POST'
        });

        yield put(updateStat());
    } catch (err) {
        yield put(agenciesStatError());
    }
}

export default function *() {
    yield all([
        takeLatest(ActionTypes.UPDATE, update)
    ]);
}
