import { Action } from 'redux-actions'; // eslint-disable-line import/named

export enum ActionTypes {
    UPDATE = '[agencies stat] update',
    AGENCIES_STAT_ERROR = '[agencies stat] error'
}

interface IDatePayload {
    date: string
}

export interface IUpdateAction extends Action<null> {
    type: ActionTypes.UPDATE
}

export interface IAgenciesStatErrorAction extends Action<null> {
    type: ActionTypes.AGENCIES_STAT_ERROR
}

export type agenciesStatAction =
    | IUpdateAction
    | IAgenciesStatErrorAction;

export type AgenciesStatPayload =
    | IDatePayload;
