import { handleActions } from 'redux-actions';

import { IStatisticsState } from '../common/types';
import { validateNumber } from '../common/helpers';

import {
    ActionTypes,
    AttemptByNumberTypePayload,
    ITypeAction
} from './types';

const initialState: IStatisticsState = {
    inputText: '',
    hasFocus: false,
    isValid: true
};

function typing(state: IStatisticsState, action: ITypeAction): IStatisticsState {
    const { inputText } = action.payload;
    const isValid = validateNumber(inputText);

    return Object.assign({}, state, {
        inputText: isValid ? inputText : state.inputText,
        isValid
    });
}

function focus(state: IStatisticsState): IStatisticsState {
    return Object.assign({}, state, { hasFocus: true });
}

function blur(state: IStatisticsState): IStatisticsState {
    return Object.assign({}, state, { hasFocus: false });
}

export default handleActions<IStatisticsState, AttemptByNumberTypePayload>({
    [ActionTypes.TYPING]: typing,
    [ActionTypes.FOCUS]: focus,
    [ActionTypes.BLUR]: blur
}, initialState);
