import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from '../common/types';

export enum ActionTypes {
    TYPING = '[attempt by number] typing',
    FOCUS = '[attempt by number] focus',
    BLUR = '[attempt by number] blur'
}

export interface ITypeAction extends Action<ITypePayload> {
    type: ActionTypes.TYPING,
    payload: ITypePayload
}

export interface IFocusAction extends Action<null> {
    type: ActionTypes.FOCUS
}

export interface IBlurAction extends Action<null> {
    type: ActionTypes.BLUR
}

export type AttemptByNumberTypePayload =
    | ITypePayload;
