import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from '../common/types';

export enum ActionTypes {
    TYPING = '[attempts by login] typing',
    FOCUS = '[attempts by login] focus',
    BLUR = '[attempts by login] blur'
}

export interface ITypeAction extends Action<ITypePayload> {
    type: ActionTypes.TYPING,
    payload: ITypePayload
}

export interface IFocusAction extends Action<null> {
    type: ActionTypes.FOCUS
}

export interface IBlurAction extends Action<null> {
    type: ActionTypes.BLUR
}

export type AttemptsByLoginTypePayload =
    | ITypePayload;
