import { IDetailsError } from 'common/utils/error';

import {
    ActionTypes,
    IBanAction,
    IBanPayload,
    IBanSuccessAction,
    IBanErrorAction,
    IBlurLoginsAction,
    IBlurReasonAction,
    IChooseExamsAction,
    IFocusLoginsAction,
    IFocusReasonAction,
    IToggleSuperbanAction,
    ITypeLoginsAction,
    ITypeReasonAction,
    IPressBanAction,
    IDeclineAction
} from './types';

export function chooseExams(exams: string[]): IChooseExamsAction {
    return { type: ActionTypes.CHOOSE_EXAMS, payload: { exams } };
}

export function typeLogins(inputText: string): ITypeLoginsAction {
    return { type: ActionTypes.TYPE_LOGINS, payload: { inputText } };
}

export function focusLogins(): IFocusLoginsAction {
    return { type: ActionTypes.FOCUS_LOGINS };
}

export function blurLogins(): IBlurLoginsAction {
    return { type: ActionTypes.BLUR_LOGINS };
}

export function typeReason(inputText: string): ITypeReasonAction {
    return { type: ActionTypes.TYPE_REASON, payload: { inputText } };
}

export function focusReason(): IFocusReasonAction {
    return { type: ActionTypes.FOCUS_REASON };
}

export function blurReason(): IBlurReasonAction {
    return { type: ActionTypes.BLUR_REASON };
}

export function toggleSuperban(): IToggleSuperbanAction {
    return { type: ActionTypes.TOGGLE_SUPERBAN };
}

export function pressBan(): IPressBanAction {
    return { type: ActionTypes.PRESS_BAN };
}

export function decline(): IDeclineAction {
    return { type: ActionTypes.DECLINE };
}

export function ban(banData: IBanPayload): IBanAction {
    return { type: ActionTypes.BAN, payload: banData };
}

export function banSuccess(): IBanSuccessAction {
    return { type: ActionTypes.BAN_SUCCESS };
}

export function banError(error: IDetailsError): IBanErrorAction {
    return { type: ActionTypes.BAN_ERROR, payload: error };
}
