import fetch from 'client/common/fetch';

import { serverUrls } from 'common/server-urls';

import { all, call, takeLatest, put } from 'redux-saga/effects';

import {
    ActionTypes,
    IBanAction
} from './types';

import {
    banSuccess,
    banError
} from './actions';

import {
    parseLogins
} from './reducer';

function *ban(action: IBanAction) {
    try {
        const { examsForBan, reason, isSuperban, logins } = action.payload;

        const parsedLogins = parseLogins(logins);
        const trialTemplateIds = examsForBan.map(examId => Number(examId));

        const associateUrl = serverUrls.associateUsers.build();

        yield call(fetch, associateUrl, {
            method: 'POST',
            body: JSON.stringify({
                logins: parsedLogins
            }),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        const banUrl = serverUrls.ban.build();

        yield call(fetch, banUrl, {
            method: 'POST',
            body: JSON.stringify({
                login: parsedLogins[0],
                isSuperban,
                reason,
                trialTemplateIds
            }),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        yield put(banSuccess());
    } catch (err) {
        yield put(banError(err.data || err));
    }
}

export default function *() {
    yield all([
        takeLatest(ActionTypes.BAN, ban)
    ]);
}
