import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from 'client/store/common/types';
import { IDetailsError } from 'common/utils/error';

export interface IBanFormState {
    examsForBan: string[],
    logins: string,
    hasFocusLogins: boolean,
    hasLogins: boolean,
    isValidLogins: boolean,
    reason: string,
    hasFocusReason: boolean,
    isSuperban: boolean,
    isPending: boolean,
    requestError: IDetailsError | null,
    isBanSuccess: boolean,
    isVisibleConfirmationModal: boolean,
    submitErrors: string[] | null
}

export enum ActionTypes {
    CHOOSE_EXAMS = '[banForm] choose exams',
    TYPE_LOGINS = '[banForm] type logins',
    FOCUS_LOGINS = '[banForm] focus logins',
    BLUR_LOGINS = '[banForm] blur logins',
    TYPE_REASON = '[banForm] type reason',
    FOCUS_REASON = '[banForm] focus reason',
    BLUR_REASON = '[banForm] blur reason',
    TOGGLE_SUPERBAN = '[banForm] toggle superban',
    PRESS_BAN = '[banForm] press ban',
    DECLINE = '[banForm] decline',
    BAN = '[banForm] ban',
    BAN_SUCCESS = '[banForm] ban success',
    BAN_ERROR = '[banForm] ban error'
}

export interface IBanPayload {
    examsForBan: string[],
    logins: string,
    reason: string,
    isSuperban: boolean
}

interface IExamsPayload {
    exams: string[]
}

export interface IChooseExamsAction extends Action<IExamsPayload> {
    type: ActionTypes.CHOOSE_EXAMS,
    payload: IExamsPayload
}

export interface ITypeLoginsAction extends Action<ITypePayload> {
    type: ActionTypes.TYPE_LOGINS,
    payload: ITypePayload
}

export interface IFocusLoginsAction extends Action<null> {
    type: ActionTypes.FOCUS_LOGINS
}

export interface IBlurLoginsAction extends Action<null> {
    type: ActionTypes.BLUR_LOGINS
}

export interface ITypeReasonAction extends Action<ITypePayload> {
    type: ActionTypes.TYPE_REASON,
    payload: ITypePayload
}

export interface IFocusReasonAction extends Action<null> {
    type: ActionTypes.FOCUS_REASON
}

export interface IBlurReasonAction extends Action<null> {
    type: ActionTypes.BLUR_REASON
}

export interface IToggleSuperbanAction extends Action<null> {
    type: ActionTypes.TOGGLE_SUPERBAN
}

export interface IPressBanAction extends Action<null> {
    type: ActionTypes.PRESS_BAN
}

export interface IDeclineAction extends Action<null> {
    type: ActionTypes.DECLINE
}

export interface IBanAction extends Action<IBanPayload> {
    type: ActionTypes.BAN,
    payload: IBanPayload
}

export interface IBanSuccessAction extends Action<null> {
    type: ActionTypes.BAN_SUCCESS
}

export interface IBanErrorAction extends Action<IDetailsError> {
    type: ActionTypes.BAN_ERROR,
    payload: IDetailsError
}

export type BanFormAction =
    | IChooseExamsAction
    | ITypeLoginsAction
    | IFocusLoginsAction
    | IBlurLoginsAction
    | ITypeReasonAction
    | IFocusReasonAction
    | IBlurReasonAction
    | IToggleSuperbanAction
    | IBanAction
    | IBanSuccessAction
    | IBanErrorAction
    | IPressBanAction
    | IDeclineAction;

export type BanFormPayload =
    | IExamsPayload
    | ITypePayload
    | IBanPayload
    | IDetailsError;
