import {
    ActionTypes,
    ITypeLoginAction,
    IFocusLoginAction,
    IBlurLoginAction,
    IGetBanInfoAction,
    IGetBanInfoSuccessAction,
    IGetBanInfoErrorAction,
    IBanError,
    IAssociationsInfo
} from './types';

export function typeLoginAction(inputText: string): ITypeLoginAction {
    return { type: ActionTypes.TYPE_LOGIN, payload: { inputText } };
}

export function focusLogin(): IFocusLoginAction {
    return { type: ActionTypes.FOCUS_LOGIN };
}

export function blurLogin(): IBlurLoginAction {
    return { type: ActionTypes.BLUR_LOGIN };
}

export function getBanInfo(login: string): IGetBanInfoAction {
    return { type: ActionTypes.GET_BANS_INFO, payload: { login } };
}

export function getBanInfoSuccess(
    banInfo: IAssociationsInfo
): IGetBanInfoSuccessAction {
    const { logins, globalUserInfo } = banInfo;

    return {
        type: ActionTypes.GET_BANS_INFO_SUCCESS,
        payload: { logins, globalUserInfo }
    };
}

export function getBanInfoError(error: IBanError): IGetBanInfoErrorAction {
    return { type: ActionTypes.GET_BANS_INFO_ERROR, payload: error };
}
