import { handleActions } from 'redux-actions';

import { validateLogin } from 'client/store/common/helpers';

import {
    ActionTypes,
    IBansState,
    BansPayload,
    ITypeLoginAction,
    IGetBanInfoSuccessAction,
    IGetBanInfoErrorAction
} from './types';

const initialState: IBansState = {
    login: '',
    hasFocusLogin: false,
    isValidLogin: true,
    isPending: false,
    requestError: null,
    associationsInfo: null
};

function typeLogin(
    state: IBansState,
    action: ITypeLoginAction
): IBansState {
    const { inputText } = action.payload;

    const isValidLogin = validateLogin(inputText);

    return Object.assign({}, state, {
        login: inputText,
        isValidLogin
    });
}

function focusLogin(state: IBansState): IBansState {
    return Object.assign({}, state, { hasFocusLogin: true });
}

function blurLogin(state: IBansState): IBansState {
    return Object.assign({}, state, { hasFocusLogin: false });
}

function getBanInfo(state: IBansState): IBansState {
    return Object.assign({}, state, {
        isPending: true,
        requestError: null,
        associationsInfo: null
    });
}

function getBanInfoSuccess(
    state: IBansState,
    action: IGetBanInfoSuccessAction
): IBansState {
    const { logins, globalUserInfo } = action.payload;

    return Object.assign({}, state, {
        isPending: false,
        requestError: null,
        associationsInfo: { logins, globalUserInfo }
    });
}

function getBanInfoError(
    state: IBansState,
    action: IGetBanInfoErrorAction
): IBansState {
    return Object.assign({}, state, {
        isPending: false,
        requestError: action.payload
    });
}

export default handleActions<IBansState, BansPayload>({
    [ActionTypes.TYPE_LOGIN]: typeLogin,
    [ActionTypes.FOCUS_LOGIN]: focusLogin,
    [ActionTypes.BLUR_LOGIN]: blurLogin,
    [ActionTypes.GET_BANS_INFO]: getBanInfo,
    [ActionTypes.GET_BANS_INFO_SUCCESS]: getBanInfoSuccess,
    [ActionTypes.GET_BANS_INFO_ERROR]: getBanInfoError
}, initialState);
