import fetch from 'client/common/fetch';

import { serverUrls } from 'common/server-urls';

import { all, call, takeLatest, put } from 'redux-saga/effects';

import {
    ActionTypes,
    IGetBanInfoAction,
    IGetBanInfoSuccessPayload
} from './types';

import {
    getBanInfoSuccess,
    getBanInfoError
} from './actions';

function *getBanInfo(action: IGetBanInfoAction) {
    try {
        const { login } = action.payload;

        const url = serverUrls.getAssociationsInfo.build({}, { login });

        const res: IGetBanInfoSuccessPayload = yield call(fetch, url);

        const { logins, globalUserInfo } = res;

        yield put(getBanInfoSuccess({ logins, globalUserInfo }));
    } catch (err) {
        yield put(getBanInfoError(err.data || err));
    }
}

export default function *() {
    yield all([
        takeLatest(ActionTypes.GET_BANS_INFO, getBanInfo)
    ]);
}
