import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from '../common/types';

export interface IBanError {
    internalCode: string,
    message: string
}

export interface IBanInfo {
    admin: { login: string },
    reason?: string,
    trialTemplateId: number,
    startedDate: string,
    expiredDate: string,
    action: string,
    isLast: boolean
}

export interface IGlobalUserInfo {
    actualLogin: string,
    isBanned: boolean,
    bans: IBanInfo[]
}

export interface IAssociationsInfo {
    logins: string[],
    globalUserInfo: IGlobalUserInfo
}

export interface IBansState {
    login: string,
    hasFocusLogin: boolean,
    isValidLogin: boolean,
    isPending: boolean,
    requestError: IBanError | null,
    associationsInfo: IAssociationsInfo | null
}

export enum ActionTypes {
    TYPE_LOGIN = '[bans] type login',
    FOCUS_LOGIN = '[bans] focus login',
    BLUR_LOGIN = '[bans] blur login',
    GET_BANS_INFO = '[bans] get ban info',
    GET_BANS_INFO_SUCCESS = '[bans] get ban info success',
    GET_BANS_INFO_ERROR = '[bans] get ban info error'
}

export interface ITypeLoginAction extends Action<ITypePayload> {
    type: ActionTypes.TYPE_LOGIN,
    payload: ITypePayload
}

export interface IFocusLoginAction extends Action<null> {
    type: ActionTypes.FOCUS_LOGIN
}

export interface IBlurLoginAction extends Action<null> {
    type: ActionTypes.BLUR_LOGIN
}

export interface IGetBanInfoPayload {
    login: string
}

export interface IGetBanInfoAction extends Action<IGetBanInfoPayload> {
    type: ActionTypes.GET_BANS_INFO,
    payload: IGetBanInfoPayload
}

export interface IGetBanInfoSuccessPayload {
    logins: string[],
    globalUserInfo: IGlobalUserInfo
}

export interface IGetBanInfoSuccessAction extends Action<IGetBanInfoSuccessPayload> {
    type: ActionTypes.GET_BANS_INFO_SUCCESS,
    payload: IGetBanInfoSuccessPayload
}

export interface IGetBanInfoErrorAction extends Action<IBanError> {
    type: ActionTypes.GET_BANS_INFO_ERROR,
    payload: IBanError
}

export type BansAction =
    | ITypeLoginAction
    | IFocusLoginAction
    | IBlurLoginAction
    | IGetBanInfoAction
    | IGetBanInfoSuccessAction
    | IGetBanInfoErrorAction;

export type BansPayload =
    | ITypePayload
    | IGetBanInfoPayload
    | IGetBanInfoSuccessPayload
    | IBanError;
