import { handleActions } from 'redux-actions';

import { PeriodDateType } from '../common/types';

import {
    ActionTypes,
    IFromDateChangeAction,
    BansAggregationPayload,
    IToDateChangeAction,
    IIntervalChoiceAction,
    IExamsChoiceAction
} from './types';

export interface IBansAggregationState {
    from: Date,
    to: Date,
    interval?: string,
    error?: PeriodDateType,
    exams: string[]
}

const fromDate = new Date();

fromDate.setMonth(fromDate.getMonth() - 1);

const initialState: IBansAggregationState = {
    from: fromDate,
    to: new Date(),
    exams: []
};

function changeFromDate(
    state: IBansAggregationState,
    action: IFromDateChangeAction
): IBansAggregationState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = to && to < date;

    return Object.assign({}, state, {
        from: hasError ? from : date,
        error: hasError ? 'from' : undefined
    });
}

function changeToDate(
    state: IBansAggregationState,
    action: IToDateChangeAction
): IBansAggregationState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = from && from > date;

    return Object.assign({}, state, {
        to: hasError ? to : date,
        error: hasError ? 'to' : undefined
    });
}

function chooseInterval(
    state: IBansAggregationState,
    action: IIntervalChoiceAction
): IBansAggregationState {
    const { interval } = action.payload;

    return Object.assign({}, state, {
        interval: Array.isArray(interval) ? interval[0] : interval
    });
}

function chooseExams(
    state: IBansAggregationState,
    action: IExamsChoiceAction
): IBansAggregationState {
    const { exams } = action.payload;

    return Object.assign({}, state, { exams });
}

export default handleActions<IBansAggregationState, BansAggregationPayload>({
    [ActionTypes.FROM_DATE_CHANGE]: changeFromDate,
    [ActionTypes.TO_DATE_CHANGE]: changeToDate,
    [ActionTypes.INTERVAL_CHOICE]: chooseInterval,
    [ActionTypes.EXAMS_CHOICE]: chooseExams
}, initialState);
