import { Action } from 'redux-actions'; // eslint-disable-line import/named

export enum ActionTypes {
    FROM_DATE_CHANGE = '[bansAggregation] start date change',
    TO_DATE_CHANGE = '[bansAggregation] end date change',
    INTERVAL_CHOICE = '[bansAggregation] interval choice',
    EXAMS_CHOICE = '[bansAggregation] exams choice'
}

interface IDatePayload {
    date: Date
}

export interface IFromDateChangeAction extends Action<IDatePayload> {
    type: ActionTypes.FROM_DATE_CHANGE,
    payload: IDatePayload
}

export interface IToDateChangeAction extends Action<IDatePayload> {
    type: ActionTypes.TO_DATE_CHANGE,
    payload: IDatePayload,
}

interface IIntervalPayload {
    interval?: string
}

export interface IIntervalChoiceAction extends Action<IIntervalPayload> {
    type: ActionTypes.INTERVAL_CHOICE,
    payload: IIntervalPayload
}

interface IExamsPayload {
    exams: string[]
}

export interface IExamsChoiceAction extends Action<IExamsPayload> {
    type: ActionTypes.EXAMS_CHOICE,
    payload: IExamsPayload
}

export type BansAggregationAction =
    | IFromDateChangeAction
    | IToDateChangeAction
    | IIntervalChoiceAction
    | IExamsChoiceAction;

export type BansAggregationPayload =
    | IDatePayload
    | IIntervalPayload
    | IExamsPayload;
