import { handleActions } from 'redux-actions';

import { validateLogin } from 'client/store/common/helpers';
import { IStatisticsState } from 'client/store/common/types';

import {
    ActionTypes,
    BansByLoginTypePayload,
    ITypeAction
} from './types';

const initialState: IStatisticsState = {
    inputText: '',
    hasFocus: false,
    isValid: true
};

function typing(state: IStatisticsState, action: ITypeAction): IStatisticsState {
    const { inputText } = action.payload;
    const isValid = validateLogin(inputText);

    return Object.assign({}, state, {
        inputText: isValid ? inputText : state.inputText,
        isValid
    });
}

function focus(state: IStatisticsState): IStatisticsState {
    return Object.assign({}, state, {
        ...state,
        hasFocus: true
    });
}

function blur(state: IStatisticsState): IStatisticsState {
    return Object.assign({}, state, {
        ...state,
        hasFocus: false
    });
}

export default handleActions<IStatisticsState, BansByLoginTypePayload>({
    [ActionTypes.TYPING]: typing,
    [ActionTypes.FOCUS]: focus,
    [ActionTypes.BLUR]: blur
}, initialState);
