import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from 'client/store/common/types';

export enum ActionTypes {
    TYPING = '[bansByLogin] typing',
    FOCUS = '[bansByLogin] focus',
    BLUR = '[bansByLogin] blur'
}

export interface ITypeAction extends Action<ITypePayload> {
    type: ActionTypes.TYPING,
    payload: ITypePayload
}

export interface IFocusAction extends Action<null> {
    type: ActionTypes.FOCUS
}

export interface IBlurAction extends Action<null> {
    type: ActionTypes.BLUR
}

export type BansByLoginTypePayload =
    | ITypePayload;
