import { handleActions } from 'redux-actions';

import { PeriodDateError } from '../common/types';

import {
    ActionTypes,
    IFromDateChangeAction,
    CertificatesByPeriodPayload,
    IToDateChangeAction,
    IExamsChoiceAction
} from './types';

export interface ICertificatesByPeriodState {
    from: Date,
    to: Date,
    error?: PeriodDateError,
    exams: string[]
}

const fromDate = new Date();

fromDate.setMonth(fromDate.getMonth() - 1);

const initialState: ICertificatesByPeriodState = {
    from: fromDate,
    to: new Date(),
    exams: []
};

function changeFromDate(
    state: ICertificatesByPeriodState,
    action: IFromDateChangeAction
): ICertificatesByPeriodState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = to && to < date;

    return Object.assign({}, state, {
        from: hasError ? from : date,
        error: hasError ? 'from' : undefined
    });
}

function changeToDate(
    state: ICertificatesByPeriodState,
    action: IToDateChangeAction
): ICertificatesByPeriodState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = from && from > date;

    return Object.assign({}, state, {
        to: hasError ? to : date,
        error: hasError ? 'to' : undefined
    });
}

function chooseExams(
    state: ICertificatesByPeriodState,
    action: IExamsChoiceAction
): ICertificatesByPeriodState {
    const { exams } = action.payload;

    return Object.assign({}, state, { exams });
}

export default handleActions<ICertificatesByPeriodState, CertificatesByPeriodPayload>({
    [ActionTypes.FROM_DATE_CHANGE]: changeFromDate,
    [ActionTypes.TO_DATE_CHANGE]: changeToDate,
    [ActionTypes.EXAMS_CHOICE]: chooseExams
}, initialState);
