import { Action } from 'redux-actions'; // eslint-disable-line import/named

export enum ActionTypes {
    FROM_DATE_CHANGE = '[certificates by period] start date change',
    TO_DATE_CHANGE = '[certificates by period] end date change',
    EXAMS_CHOICE = '[certificates by period] exams choice'
}

interface IDatePayload {
    date: Date
}

export interface IFromDateChangeAction extends Action<IDatePayload> {
    type: ActionTypes.FROM_DATE_CHANGE,
    payload: IDatePayload
}

export interface IToDateChangeAction extends Action<IDatePayload> {
    type: ActionTypes.TO_DATE_CHANGE,
    payload: IDatePayload,
}

interface IExamsPayload {
    exams: string[]
}

export interface IExamsChoiceAction extends Action<IExamsPayload> {
    type: ActionTypes.EXAMS_CHOICE,
    payload: IExamsPayload
}

export type CertificatesByPeriodAction =
    | IFromDateChangeAction
    | IToDateChangeAction
    | IExamsChoiceAction;

export type CertificatesByPeriodPayload =
    | IDatePayload
    | IExamsPayload;
