export function validateNumber(inputText: string): boolean {
    return inputText.length === 0 || Boolean(inputText.match(/^[\d]+$/));
}

export function validateLogin(inputText: string): boolean {
    return inputText.length === 0 || /^[a-zA-Z\d\-_.@]+$/.test(inputText);
}

export function validateEmail(inputText: string): boolean {
    return inputText.length === 0 || /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(inputText);
}
