import { handleActions } from 'redux-actions';

import {
    ActionTypes,
    CommonPayload,
    ICommonState,
    IChangePageAction
} from './types';

const initialState: ICommonState = {
    page: ''
};

function changePage(state: ICommonState, action: IChangePageAction): ICommonState {
    return Object.assign({}, state, { page: action.payload.name });
}

export default handleActions<ICommonState, CommonPayload>({
    [ActionTypes.CHANGE_PAGE]: changePage
}, initialState);
