import { Action } from 'redux-actions';// eslint-disable-line import/named

export enum ActionTypes {
    CHANGE_PAGE = '[common] change page'
}

export interface ICommonState {
    page: string
}

export interface IStatisticsState {
    inputText: string,
    hasFocus: boolean,
    isValid?: boolean
}

export interface ITypePayload {
    inputText: string
}

interface IChangePagePayload {
    name: string
}

export type PeriodDateType = 'from' | 'to';

export type PeriodDateError = PeriodDateType;

export interface IChangePageAction extends Action<IChangePagePayload> {
    type: ActionTypes.CHANGE_PAGE,
    payload: IChangePagePayload
}

export type CommonPayload =
    | IChangePagePayload;
