import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from '../common/types';

export enum ActionTypes {
    TYPING = '[data by cert number] typing',
    FOCUS = '[data by cert number] focus',
    BLUR = '[data by cert number] blur'
}

export interface ITypeAction extends Action<ITypePayload> {
    type: ActionTypes.TYPING,
    payload: ITypePayload
}

export interface IFocusAction extends Action<null> {
    type: ActionTypes.FOCUS
}

export interface IBlurAction extends Action<null> {
    type: ActionTypes.BLUR
}

export type DataByCertNumberTypePayload =
    | ITypePayload;
