import { handleActions } from 'redux-actions';

import { PeriodDateType } from '../common/types';

import {
    ActionTypes,
    IFromDateChangeAction,
    DataByPeriodPayload,
    IToDateChangeAction,
    IIntervalChoiceAction,
    IExamsChoiceAction
} from './types';

export interface IDataByPeriodState {
    from: Date,
    to: Date,
    interval?: string,
    error?: PeriodDateType,
    exams: string[]
}

const fromDate = new Date();

fromDate.setMonth(fromDate.getMonth() - 1);

const initialState: IDataByPeriodState = {
    from: fromDate,
    to: new Date(),
    exams: []
};

function changeFromDate(
    state: IDataByPeriodState,
    action: IFromDateChangeAction
): IDataByPeriodState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = to && to < date;

    return Object.assign({}, state, {
        from: hasError ? from : date,
        error: hasError ? 'from' : undefined
    });
}

function changeToDate(state: IDataByPeriodState, action: IToDateChangeAction): IDataByPeriodState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = from && from > date;

    return Object.assign({}, state, {
        to: hasError ? to : date,
        error: hasError ? 'to' : undefined
    });
}

function chooseInterval(
    state: IDataByPeriodState,
    action: IIntervalChoiceAction
): IDataByPeriodState {
    const { interval } = action.payload;

    return Object.assign({}, state, {
        interval: Array.isArray(interval) ? interval[0] : interval
    });
}

function chooseExams(state: IDataByPeriodState, action: IExamsChoiceAction): IDataByPeriodState {
    const { exams } = action.payload;

    return Object.assign({}, state, { exams });
}

export default handleActions<IDataByPeriodState, DataByPeriodPayload>({
    [ActionTypes.FROM_DATE_CHANGE]: changeFromDate,
    [ActionTypes.TO_DATE_CHANGE]: changeToDate,
    [ActionTypes.INTERVAL_CHOICE]: chooseInterval,
    [ActionTypes.EXAMS_CHOICE]: chooseExams
}, initialState);
