import IExamSettings from '../../../common/types/examSettings';

import {
    ActionTypes,
    IChangeDescription,
    IChangeOgDescription,
    IChangeRules,
    IChangeSeoDescription,
    IChangeTimeLimit,
    IChangeTitle,
    ISaveSettings,
    ISwitchTitleEdit,
    ISaveSettingsSuccess,
    ISaveSettingsError,
    ISaveFormError
} from './types';

export function changeTimeLimit(timeLimit: number): IChangeTimeLimit {
    return { type: ActionTypes.CHANGE_TIME_LIMIT, payload: { timeLimit } };
}

export function changeRules(rules: string): IChangeRules {
    return { type: ActionTypes.CHANGE_RULES, payload: { rules } };
}

export function changeDescription(description: string): IChangeDescription {
    return { type: ActionTypes.CHANGE_DESCRIPTION, payload: { description } };
}

export function changeSeoDescription(seoDescription: string): IChangeSeoDescription {
    return { type: ActionTypes.CHANGE_SEO_DESCRIPTION, payload: { seoDescription } };
}

export function changeOgDescription(ogDescription: string): IChangeOgDescription {
    return { type: ActionTypes.CHANGE_OG_DESCRIPTION, payload: { ogDescription } };
}

export function changeTitle(title: string): IChangeTitle {
    return { type: ActionTypes.CHANGE_TITLE, payload: { title } };
}

export function switchTitleEdit(isEditingTitle: boolean): ISwitchTitleEdit {
    return { type: ActionTypes.SWITCH_TITLE_EDIT, payload: { isEditingTitle } };
}

export function saveSettings(exam: IExamSettings): ISaveSettings {
    return { type: ActionTypes.SAVE_SETTINGS, payload: { exam } };
}

export function saveSettingsSuccess(): ISaveSettingsSuccess {
    return { type: ActionTypes.SAVE_SETTINGS_SUCCESS };
}

export function saveSettingsError(error: ISaveFormError): ISaveSettingsError {
    return { type: ActionTypes.SAVE_SETTINGS_ERROR, payload: error };
}
