import { handleActions } from 'redux-actions';

import {
    ActionTypes,
    IChangeTimeLimit,
    IChangeRules,
    IChangeDescription,
    IChangeSeoDescription,
    IChangeOgDescription,
    IEditExamFormState,
    IChangeTitle,
    ISwitchTitleEdit,
    ISaveSettingsError
} from './types';

const initialState: IEditExamFormState = {
    timeLimit: 0,
    title: '',
    description: '',
    rules: '',
    seoDescription: '',
    ogDescription: '',
    isEditingTitle: false,
    isSavePending: false,
    isSaveSuccess: false,
    saveError: null
};

function changeTimeLimit(
    state: IEditExamFormState,
    action: IChangeTimeLimit
): IEditExamFormState {
    const { timeLimit } = action.payload;

    return {
        ...state,
        isSaveSuccess: false,
        saveError: null,
        timeLimit
    };
}

function changeRules(
    state: IEditExamFormState,
    action: IChangeRules
): IEditExamFormState {
    const { rules } = action.payload;

    return {
        ...state,
        isSaveSuccess: false,
        saveError: null,
        rules
    };
}

function changeDescription(
    state: IEditExamFormState,
    action: IChangeDescription
): IEditExamFormState {
    const { description } = action.payload;

    return {
        ...state,
        isSaveSuccess: false,
        saveError: null,
        description
    };
}

function changeSeoDescription(
    state: IEditExamFormState,
    action: IChangeSeoDescription
): IEditExamFormState {
    const { seoDescription } = action.payload;

    return {
        ...state,
        isSaveSuccess: false,
        saveError: null,
        seoDescription
    };
}

function changeOgDescription(
    state: IEditExamFormState,
    action: IChangeOgDescription
): IEditExamFormState {
    const { ogDescription } = action.payload;

    return {
        ...state,
        isSaveSuccess: false,
        saveError: null,
        ogDescription
    };
}

function changeTitle(
    state: IEditExamFormState,
    action: IChangeTitle
): IEditExamFormState {
    const { title } = action.payload;

    return {
        ...state,
        isSaveSuccess: false,
        saveError: null,
        title
    };
}

function switchTitleEdit(
    state: IEditExamFormState,
    action: ISwitchTitleEdit
): IEditExamFormState {
    const { isEditingTitle } = action.payload;

    return {
        ...state,
        isSaveSuccess: false,
        saveError: null,
        isEditingTitle
    };
}

function saveSettings(
    state: IEditExamFormState
): IEditExamFormState {
    return {
        ...state,
        isSavePending: true,
        isSaveSuccess: false,
        saveError: null
    };
}

function saveSettingsSuccess(
    state: IEditExamFormState
): IEditExamFormState {
    return {
        ...state,
        isSavePending: false,
        isSaveSuccess: true
    };
}

function saveSettingsError(
    state: IEditExamFormState,
    action: ISaveSettingsError
): IEditExamFormState {
    return {
        ...state,
        isSavePending: false,
        saveError: action.payload
    };
}

export default handleActions<IEditExamFormState, any>({
    [ActionTypes.CHANGE_TIME_LIMIT]: changeTimeLimit,
    [ActionTypes.CHANGE_RULES]: changeRules,
    [ActionTypes.CHANGE_DESCRIPTION]: changeDescription,
    [ActionTypes.CHANGE_SEO_DESCRIPTION]: changeSeoDescription,
    [ActionTypes.CHANGE_OG_DESCRIPTION]: changeOgDescription,
    [ActionTypes.CHANGE_TITLE]: changeTitle,
    [ActionTypes.SWITCH_TITLE_EDIT]: switchTitleEdit,
    [ActionTypes.SAVE_SETTINGS]: saveSettings,
    [ActionTypes.SAVE_SETTINGS_SUCCESS]: saveSettingsSuccess,
    [ActionTypes.SAVE_SETTINGS_ERROR]: saveSettingsError
}, initialState);
