import { all, call, takeLatest, put } from 'redux-saga/effects';

import { serverUrls } from '../../../common/server-urls';

import fetch from '../../common/fetch';

import { ActionTypes, ISaveSettings } from './types';
import { saveSettingsError, saveSettingsSuccess } from './actions';

function *saveSettings(action: ISaveSettings) {
    try {
        const { exam } = action.payload;
        const url = serverUrls.examSettings.build({ examIdentity: exam.slug });

        yield call(fetch, url, {
            method: 'POST',
            body: JSON.stringify(exam),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        yield put(saveSettingsSuccess());
    } catch (err) {
        yield put(saveSettingsError(err.data || err));
    }
}

export default function *() {
    yield all([
        takeLatest(ActionTypes.SAVE_SETTINGS, saveSettings)
    ]);
}
