import { Action } from 'redux';

import IExamSettings from 'common/types/examSettings';

export interface ISaveFormError {
    internalCode: string,
    message: string
}

export interface IEditExamFormState {
    timeLimit: number,
    title: string,
    rules: string,
    description: string,
    seoDescription: string,
    ogDescription: string,
    isEditingTitle: boolean,
    isSavePending: boolean,
    isSaveSuccess: boolean,
    saveError: ISaveFormError | null
}

export enum ActionTypes {
    CHANGE_TIME_LIMIT = '[editExamForm] change time limit',
    CHANGE_RULES = '[editExamForm] change rules',
    CHANGE_DESCRIPTION = '[editExamForm] change description',
    CHANGE_SEO_DESCRIPTION = '[editExamForm] change seo description',
    CHANGE_OG_DESCRIPTION = '[editExamForm] change og description',
    CHANGE_TITLE = '[editExamForm] change title',
    SWITCH_TITLE_EDIT ='[editExamForm] toggle title edit',
    SAVE_SETTINGS ='[editExamForm] save settings',
    SAVE_SETTINGS_SUCCESS ='[editExamForm] save settings success',
    SAVE_SETTINGS_ERROR ='[editExamForm] save settings error'
}

export interface IChangeTimeLimit extends Action {
    type: ActionTypes.CHANGE_TIME_LIMIT,
    payload: { timeLimit: number }
}

export interface IChangeRules extends Action {
    type: ActionTypes.CHANGE_RULES,
    payload: { rules: string }
}

export interface IChangeDescription extends Action {
    type: ActionTypes.CHANGE_DESCRIPTION,
    payload: { description: string }
}

export interface IChangeSeoDescription extends Action {
    type: ActionTypes.CHANGE_SEO_DESCRIPTION,
    payload: { seoDescription: string }
}
export interface IChangeOgDescription extends Action {
    type: ActionTypes.CHANGE_OG_DESCRIPTION,
    payload: { ogDescription: string }
}

export interface IChangeTitle extends Action {
    type: ActionTypes.CHANGE_TITLE,
    payload: { title: string }
}

export interface ISwitchTitleEdit extends Action {
    type: ActionTypes.SWITCH_TITLE_EDIT,
    payload: { isEditingTitle: boolean }
}

export interface ISaveSettings extends Action {
    type: ActionTypes.SAVE_SETTINGS,
    payload: { exam: IExamSettings }
}

export interface ISaveSettingsSuccess extends Action {
    type: ActionTypes.SAVE_SETTINGS_SUCCESS
}

export interface ISaveSettingsError extends Action {
    type: ActionTypes.SAVE_SETTINGS_ERROR,
    payload: ISaveFormError
}

export type IEditExamFormAction =
    | IChangeTimeLimit
    | IChangeRules
    | IChangeDescription
    | IChangeSeoDescription
    | IChangeOgDescription
    | IChangeTitle
    | ISwitchTitleEdit;
