import ITestData from 'common/types/testData';
import IEditTestData from 'common/types/editTestData';
import { IDetailsError } from 'common/utils/error';

import {
    ActionTypes,
    IAddAnswer,
    IAddAnswerPayload,
    IAddCategory,
    IAddCategoryPayload,
    IAddQuestion,
    IAddQuestionPayload,
    IAddSection,
    IAddSectionPayload,
    IChangeAnswerText,
    IChangeAnswerTextPayload,
    IChangeQuestionText,
    IChangeQuestionTextPayload,
    ICloseCategory,
    IDeclineDeleteDraft,
    IDeclinePublish,
    IDeleteDraft,
    IDeleteDraftError,
    IDeleteDraftSuccess,
    IDownloadJSON,
    IDownloadJSONError,
    IDownloadJSONSuccess,
    IEditAnswerCorrect,
    IEditAnswerCorrectPayload,
    IEditCategoryQuantity,
    IEditCategoryQuantityPayload,
    IEditQuestionType,
    IEditQuestionTypePayload,
    IEditSectionAllowedFails,
    IEditSectionAllowedFailsPayload,
    ILoadFile,
    ILoadFileError,
    ILoadFileSuccess,
    IOpenCategory,
    IPressDeleteDraft,
    IPressPublish,
    IPublishExam,
    IPublishFailed,
    IPublishSuccess,
    ISaveDraft,
    ISaveDraftError,
    ISaveDraftSuccess,
    ISendDraftForModeration,
    ISendDraftForModerationError,
    ISendDraftForModerationSuccess,
    IStartEdit,
    IStartEditError,
    IStartEditSuccess,
    IToggleRemoveAnswer,
    IToggleRemoveAnswerPayload,
    IToggleRemoveCategory,
    IToggleRemoveCategoryPayload,
    IToggleRemoveQuestion,
    IToggleRemoveQuestionPayload,
    IToggleRemoveSection,
    IToggleRemoveSectionPayload,
    ICancelChanges,
    ICancelChangesSuccess,
    ICancelChangesError,
    IPressCancelChanges,
    IDeclineCancelChanges
} from './types';

export function loadFile(examSlug: string, formData: FormData): ILoadFile {
    return {
        type: ActionTypes.LOAD_FILE,
        payload: {
            examSlug,
            data: formData
        }
    };
}

export function loadFileSuccess(response: ITestData, publishedData: ITestData): ILoadFileSuccess {
    return {
        type: ActionTypes.LOAD_FILE_SUCCESS,
        payload: {
            fileData: response,
            publishedData
        }
    };
}

export function loadFileFailed(error: IDetailsError): ILoadFileError {
    return { type: ActionTypes.LOAD_FILE_ERROR, payload: error };
}

export function downloadJSON(examSlug: string): IDownloadJSON {
    return { type: ActionTypes.DOWNLOAD_JSON, payload: { examSlug } };
}

export function downloadJSONSuccess(publishedData: ITestData): IDownloadJSONSuccess {
    return {
        type: ActionTypes.DOWNLOAD_JSON_SUCCESS,
        payload: { publishedData }
    };
}

export function downloadJSONFailed(error: IDetailsError): IDownloadJSONError {
    return { type: ActionTypes.DOWNLOAD_JSON_ERROR, payload: error };
}

export function openCategory(sectionCode: string, categoryId: number): IOpenCategory {
    return { type: ActionTypes.OPEN_CATEGORY, payload: { sectionCode, categoryId } };
}

export function closeCategory(): ICloseCategory {
    return { type: ActionTypes.CLOSE_CATEGORY };
}

export function publishExam(
    examSlug: string,
    editData: IEditTestData,
    examId: number
): IPublishExam {
    return { type: ActionTypes.PUBLISH_EXAM, payload: { examSlug, editData, examId } };
}

export function publishSuccess(): IPublishSuccess {
    return { type: ActionTypes.PUBLISH_SUCCESS };
}

export function publishFailed(error: IDetailsError): IPublishFailed {
    return { type: ActionTypes.PUBLISH_FAILED, payload: error };
}

export function declinePublish(): IDeclinePublish {
    return { type: ActionTypes.DECLINE_PUBLISH };
}

export function showPublishModal(): IPressPublish {
    return { type: ActionTypes.PRESS_PUBLISH };
}

export function deleteDraft(examSlug: string): IDeleteDraft {
    return { type: ActionTypes.DELETE_DRAFT, payload: { examSlug } };
}

export function deleteDraftSuccess(): IDeleteDraftSuccess {
    return { type: ActionTypes.DELETE_DRAFT_SUCCESS };
}

export function deleteDraftError(error: IDetailsError): IDeleteDraftError {
    return { type: ActionTypes.DELETE_DRAFT_ERROR, payload: error };
}

export function showDeleteDraftModal(): IPressDeleteDraft {
    return { type: ActionTypes.PRESS_DELETE_DRAFT };
}

export function declineDeleteDraft(): IDeclineDeleteDraft {
    return { type: ActionTypes.DECLINE_DELETE_DRAFT };
}

export function startEdit(examSlug: string): IStartEdit {
    return { type: ActionTypes.START_EDIT, payload: { examSlug } };
}

export function startEditSuccess(exam: ITestData, publishedData: ITestData): IStartEditSuccess {
    return {
        type: ActionTypes.START_EDIT_SUCCESS,
        payload: {
            draft: exam,
            publishedData
        }
    };
}

export function startEditError(error: IDetailsError): IStartEditError {
    return { type: ActionTypes.START_EDIT_ERROR, payload: error };
}

export function saveDraft(examSlug: string, examId: number, editData: IEditTestData): ISaveDraft {
    return { type: ActionTypes.SAVE_DRAFT, payload: { examSlug, examId, editData } };
}

export function saveDraftSuccess(): ISaveDraftSuccess {
    return { type: ActionTypes.SAVE_DRAFT_SUCCESS };
}

export function saveDraftError(error: IDetailsError): ISaveDraftError {
    return { type: ActionTypes.SAVE_DRAFT_ERROR, payload: error };
}

export function sendDraftForModeration(
    examSlug: string,
    examId: number,
    editData: IEditTestData
): ISendDraftForModeration {
    return { type: ActionTypes.SEND_DRAFT_FOR_MODERATION, payload: { examId, editData, examSlug } };
}

export function sendDraftForModerationSuccess(): ISendDraftForModerationSuccess {
    return { type: ActionTypes.SEND_DRAFT_FOR_MODERATION_SUCCESS };
}

export function sendDraftForModerationError(error: IDetailsError): ISendDraftForModerationError {
    return { type: ActionTypes.SEND_DRAFT_FOR_MODERATION_ERROR, payload: error };
}

export function editAnswerCorrect(data: IEditAnswerCorrectPayload): IEditAnswerCorrect {
    return { type: ActionTypes.EDIT_ANSWER_CORRECT, payload: data };
}

export function editQuestionType(data: IEditQuestionTypePayload): IEditQuestionType {
    return { type: ActionTypes.EDIT_QUESTION_TYPE, payload: data };
}

export function editCategoryQuantity(data: IEditCategoryQuantityPayload): IEditCategoryQuantity {
    return { type: ActionTypes.EDIT_CATEGORY_QUANTITY, payload: data };
}

export function editSectionAllowedFails(
    data: IEditSectionAllowedFailsPayload
): IEditSectionAllowedFails {
    return { type: ActionTypes.EDIT_SECTION_ALLOWED_FAILS, payload: data };
}

export function toggleRemoveAnswer(data: IToggleRemoveAnswerPayload): IToggleRemoveAnswer {
    return { type: ActionTypes.TOGGLE_REMOVE_ANSWER, payload: data };
}

export function toggleRemoveQuestion(data: IToggleRemoveQuestionPayload): IToggleRemoveQuestion {
    return { type: ActionTypes.TOGGLE_REMOVE_QUESTION, payload: data };
}

export function toggleRemoveCategory(data: IToggleRemoveCategoryPayload): IToggleRemoveCategory {
    return { type: ActionTypes.TOGGLE_REMOVE_CATEGORY, payload: data };
}

export function toggleRemoveSection(data: IToggleRemoveSectionPayload): IToggleRemoveSection {
    return { type: ActionTypes.TOGGLE_REMOVE_SECTION, payload: data };
}

export function changeAnswerText(data: IChangeAnswerTextPayload): IChangeAnswerText {
    return { type: ActionTypes.CHANGE_ANSWER_TEXT, payload: data };
}

export function changeQuestionText(data: IChangeQuestionTextPayload): IChangeQuestionText {
    return { type: ActionTypes.CHANGE_QUESTION_TEXT, payload: data };
}

export function addAnswer(data: IAddAnswerPayload): IAddAnswer {
    return { type: ActionTypes.ADD_ANSWER, payload: data };
}

export function addQuestion(data: IAddQuestionPayload): IAddQuestion {
    return { type: ActionTypes.ADD_QUESTION, payload: data };
}

export function addCategory(data: IAddCategoryPayload): IAddCategory {
    return { type: ActionTypes.ADD_CATEGORY, payload: data };
}

export function addSection(data: IAddSectionPayload): IAddSection {
    return { type: ActionTypes.ADD_SECTION, payload: data };
}

export function cancelChanges(examSlug: string): ICancelChanges {
    return { type: ActionTypes.CANCEL_CHANGES, payload: { examSlug } };
}

export function cancelChangesSuccess(): ICancelChangesSuccess {
    return { type: ActionTypes.CANCEL_CHANGES_SUCCESS };
}

export function cancelChangesError(error: IDetailsError): ICancelChangesError {
    return { type: ActionTypes.CANCEL_CHANGES_ERROR, payload: error };
}

export function showCancelChangesModal(): IPressCancelChanges {
    return { type: ActionTypes.PRESS_CANCEL_CHANGES };
}

export function declineCancelChanges(): IDeclineCancelChanges {
    return { type: ActionTypes.DECLINE_CANCEL_CHANGES };
}
