import { Action } from 'redux';

import ITestData from 'common/types/testData';
import { IDetailsError } from 'common/utils/error';
import RequestStatus from 'common/types/requestStatus';
import IEditTestData from 'common/types/editTestData';
import DraftStatus from 'common/types/draftStatus';

export interface IExamDataState {
    draftStatus: DraftStatus | null,
    loadStatus: RequestStatus | null,
    startEditStatus: RequestStatus | null,
    publishStatus: RequestStatus | null,
    saveDraftStatus: RequestStatus | null,
    sendDraftForModerationStatus: RequestStatus | null,
    deleteDraftStatus: RequestStatus | null,
    requestError: IDetailsError | null,
    exam: ITestData | null,
    notEditedData: IEditTestData | null,
    editData: IEditTestData | null,
    openedCategoryId: number | null,
    openedSectionCode: string | null,
    isVisiblePublishModal: boolean,
    isVisibleDeleteDraftModal: boolean,
    isVisibleCancelChangesModal: boolean,
    cancelChangesStatus: RequestStatus | null,
    isEditMode: boolean,
    maxIds: {
        category: number,
        question: number,
        answer: number
    } | null
}

export enum ActionTypes {
    LOAD_FILE = '[examData] load file',
    LOAD_FILE_SUCCESS ='[examData] load file success',
    LOAD_FILE_ERROR ='[examData] load file error',
    OPEN_CATEGORY = '[examData] open category',
    CLOSE_CATEGORY = '[examData] close category',
    DOWNLOAD_JSON = '[examData] download json',
    DOWNLOAD_JSON_SUCCESS = '[examData] download json success',
    DOWNLOAD_JSON_ERROR = '[examData] download json error',
    PUBLISH_EXAM = '[examData] publish exam',
    PUBLISH_SUCCESS = '[examData] publish success',
    PUBLISH_FAILED = '[examData] publish failed',
    DECLINE_PUBLISH = '[examData] decline publish',
    PRESS_PUBLISH = '[examData] press publish',
    START_EDIT = '[examData] start edit exam',
    START_EDIT_SUCCESS = '[examData] start edit exam success',
    START_EDIT_ERROR = '[examData] start edit exam error',
    SAVE_DRAFT = '[examData] save draft',
    SAVE_DRAFT_SUCCESS = '[examData] save draft success',
    SAVE_DRAFT_ERROR = '[examData] save draft error',
    SEND_DRAFT_FOR_MODERATION = '[examData] send draft for moderation',
    SEND_DRAFT_FOR_MODERATION_SUCCESS = '[examData] send draft for moderation success',
    SEND_DRAFT_FOR_MODERATION_ERROR = '[examData] send draft for moderation error',
    PRESS_DELETE_DRAFT = '[examData] press delete draft',
    DECLINE_DELETE_DRAFT = '[examData] decline delete draft',
    DELETE_DRAFT = '[examData] delete draft',
    DELETE_DRAFT_SUCCESS = '[examData] delete draft success',
    DELETE_DRAFT_ERROR = '[examData] delete draft error',
    EDIT_ANSWER_CORRECT = '[examData] edit answer correct',
    EDIT_QUESTION_TYPE = '[examData] edit question type',
    EDIT_CATEGORY_QUANTITY = '[examData] edit category quantity',
    EDIT_SECTION_ALLOWED_FAILS = '[examData] edit section allowed fails',
    TOGGLE_REMOVE_ANSWER = '[examData] toggle remove answer',
    TOGGLE_REMOVE_QUESTION = '[examData] toggle remove question',
    TOGGLE_REMOVE_CATEGORY = '[examData] toggle remove category',
    TOGGLE_REMOVE_SECTION = '[examData] toggle remove section',
    CHANGE_ANSWER_TEXT = '[examData] change answer text',
    CHANGE_QUESTION_TEXT = '[examData] change question text',
    ADD_ANSWER = '[examData] add answer',
    ADD_QUESTION = '[examData] add question',
    ADD_CATEGORY = '[examData] add category',
    ADD_SECTION = '[examData] add section',
    CANCEL_CHANGES = '[examData] cancel changes',
    CANCEL_CHANGES_SUCCESS = '[examData] cancel changes success',
    CANCEL_CHANGES_ERROR = '[examData] cancel changes error',
    PRESS_CANCEL_CHANGES = '[examData] press cancel changes',
    DECLINE_CANCEL_CHANGES = '[examData] decline cancel changes'
}

interface IOpenCategoryPayload {
    categoryId: number,
    sectionCode: string
}

interface IDownloadJSONPayload {
    examSlug: string
}

interface IStartEditPayload {
    examSlug: string
}

interface ISaveDraftPayload {
    examSlug: string,
    examId: number,
    editData: IEditTestData
}

interface IPublishExamPayload {
    examId: number,
    editData: IEditTestData,
    examSlug: string
}

interface IDeleteDraftPayload {
    examSlug: string
}

interface ICancelChangesPayload {
    examSlug: string
}

interface ILoadFilePayload {
    examSlug: string,
    data: FormData
}

interface ILoadFileSuccessPayload {
    fileData: ITestData,
    publishedData: ITestData
}

interface IDownloadJSONSuccessPayload {
    publishedData: ITestData
}

export interface ILoadFile extends Action {
    type: ActionTypes.LOAD_FILE,
    payload: ILoadFilePayload
}

export interface ILoadFileSuccess extends Action {
    type: ActionTypes.LOAD_FILE_SUCCESS,
    payload: ILoadFileSuccessPayload
}

export interface ILoadFileError extends Action {
    type: ActionTypes.LOAD_FILE_ERROR,
    payload: IDetailsError
}

export interface IOpenCategory extends Action {
    type: ActionTypes.OPEN_CATEGORY,
    payload: IOpenCategoryPayload
}

export interface ICloseCategory extends Action {
    type: ActionTypes.CLOSE_CATEGORY
}

export interface IDownloadJSON extends Action {
    type: ActionTypes.DOWNLOAD_JSON,
    payload: IDownloadJSONPayload
}

export interface IDownloadJSONSuccess extends Action {
    type: ActionTypes.DOWNLOAD_JSON_SUCCESS,
    payload: IDownloadJSONSuccessPayload
}

export interface IDownloadJSONError extends Action {
    type: ActionTypes.DOWNLOAD_JSON_ERROR,
    payload: IDetailsError
}

export interface IPublishFailed extends Action {
    type: ActionTypes.PUBLISH_FAILED,
    payload: IDetailsError
}

export interface IPublishExam extends Action {
    type: ActionTypes.PUBLISH_EXAM,
    payload: IPublishExamPayload
}

export interface IPublishSuccess extends Action {
    type: ActionTypes.PUBLISH_SUCCESS
}

export interface IDeclinePublish extends Action {
    type: ActionTypes.DECLINE_PUBLISH
}

export interface IPressPublish extends Action {
    type: ActionTypes.PRESS_PUBLISH
}

export interface IPressDeleteDraft extends Action {
    type: ActionTypes.PRESS_DELETE_DRAFT
}

export interface IDeclineDeleteDraft extends Action {
    type: ActionTypes.DECLINE_DELETE_DRAFT
}

export interface IDeleteDraft extends Action {
    type: ActionTypes.DELETE_DRAFT,
    payload: IDeleteDraftPayload
}

export interface IDeleteDraftSuccess extends Action {
    type: ActionTypes.DELETE_DRAFT_SUCCESS
}

export interface IDeleteDraftError extends Action {
    type: ActionTypes.DELETE_DRAFT_ERROR,
    payload: IDetailsError
}

export interface IStartEdit extends Action {
    type: ActionTypes.START_EDIT,
    payload: IStartEditPayload
}

export interface IStartEditSuccess extends Action {
    type: ActionTypes.START_EDIT_SUCCESS,
    payload: {
        draft: ITestData,
        publishedData: ITestData
    }
}

export interface IStartEditError extends Action {
    type: ActionTypes.START_EDIT_ERROR,
    payload: IDetailsError
}

export interface ISaveDraft extends Action {
    type: ActionTypes.SAVE_DRAFT,
    payload: ISaveDraftPayload
}

export interface ISaveDraftSuccess extends Action {
    type: ActionTypes.SAVE_DRAFT_SUCCESS
}

export interface ISaveDraftError extends Action {
    type: ActionTypes.SAVE_DRAFT_ERROR,
    payload: IDetailsError
}

export interface ISendDraftForModerationPayload {
    editData: IEditTestData,
    examId: number,
    examSlug: string
}

export interface ISendDraftForModeration extends Action {
    type: ActionTypes.SEND_DRAFT_FOR_MODERATION,
    payload: ISendDraftForModerationPayload
}

export interface ISendDraftForModerationSuccess extends Action {
    type: ActionTypes.SEND_DRAFT_FOR_MODERATION_SUCCESS
}

export interface ISendDraftForModerationError extends Action {
    type: ActionTypes.SEND_DRAFT_FOR_MODERATION_ERROR,
    payload: IDetailsError
}

export interface IEditAnswerCorrectPayload {
    sectionCode: string,
    categoryId: number,
    questionId: number,
    answerId: number,
    correct: number
}

export interface IEditAnswerCorrect extends Action {
    type: ActionTypes.EDIT_ANSWER_CORRECT,
    payload: IEditAnswerCorrectPayload
}

export interface IEditQuestionTypePayload {
    sectionCode: string,
    categoryId: number,
    questionId: number,
    type: number
}

export interface IEditQuestionType extends Action {
    type: ActionTypes.EDIT_QUESTION_TYPE,
    payload: IEditQuestionTypePayload
}

export interface IEditCategoryQuantityPayload {
    sectionCode: string,
    categoryId: number,
    quantity: number
}

export interface IEditCategoryQuantity extends Action {
    type: ActionTypes.EDIT_CATEGORY_QUANTITY,
    payload: IEditCategoryQuantityPayload
}

export interface IEditSectionAllowedFailsPayload {
    sectionCode: string,
    allowedFails: number
}

export interface IEditSectionAllowedFails extends Action {
    type: ActionTypes.EDIT_SECTION_ALLOWED_FAILS,
    payload: IEditSectionAllowedFailsPayload
}

export interface IToggleRemoveAnswerPayload {
    sectionCode: string,
    categoryId: number,
    questionId: number,
    answerId: number,
    isRemoved: boolean
}

export interface IToggleRemoveAnswer extends Action {
    type: ActionTypes.TOGGLE_REMOVE_ANSWER,
    payload: IToggleRemoveAnswerPayload
}

export interface IToggleRemoveQuestionPayload {
    sectionCode: string,
    categoryId: number,
    questionId: number,
    isRemoved: boolean
}

export interface IToggleRemoveQuestion extends Action {
    type: ActionTypes.TOGGLE_REMOVE_QUESTION,
    payload: IToggleRemoveQuestionPayload
}

export interface IToggleRemoveCategoryPayload {
    sectionCode: string,
    categoryId: number,
    isRemoved: boolean
}

export interface IToggleRemoveCategory extends Action {
    type: ActionTypes.TOGGLE_REMOVE_CATEGORY,
    payload: IToggleRemoveCategoryPayload
}

export interface IToggleRemoveSectionPayload {
    sectionCode: string,
    isRemoved: boolean
}

export interface IToggleRemoveSection extends Action {
    type: ActionTypes.TOGGLE_REMOVE_SECTION,
    payload: IToggleRemoveSectionPayload
}

export interface IChangeAnswerTextPayload {
    sectionCode: string,
    categoryId: number,
    questionId: number,
    answerId: number,
    text: string
}

export interface IChangeAnswerText extends Action {
    type: ActionTypes.CHANGE_ANSWER_TEXT,
    payload: IChangeAnswerTextPayload
}

export interface IChangeQuestionTextPayload {
    sectionCode: string,
    categoryId: number,
    questionId: number,
    text: string
}

export interface IChangeQuestionText extends Action {
    type: ActionTypes.CHANGE_QUESTION_TEXT,
    payload: IChangeQuestionTextPayload
}

export interface IAddAnswerPayload {
    sectionCode: string,
    categoryId: number,
    questionId: number
}

export interface IAddAnswer extends Action {
    type: ActionTypes.ADD_ANSWER,
    payload: IAddAnswerPayload
}

export interface IAddQuestionPayload {
    sectionCode: string,
    categoryId: number
}

export interface IAddQuestion extends Action {
    type: ActionTypes.ADD_QUESTION,
    payload: IAddQuestionPayload
}

export interface IAddCategoryPayload {
    sectionCode: string
}

export interface IAddCategory extends Action {
    type: ActionTypes.ADD_CATEGORY,
    payload: IAddCategoryPayload
}

export interface IAddSectionPayload {
    sectionCode: string,
    title: string,
    allowedFails: number,
    serviceId: number
}

export interface IAddSection extends Action {
    type: ActionTypes.ADD_SECTION,
    payload: IAddSectionPayload
}

export interface ICancelChanges extends Action {
    type: ActionTypes.CANCEL_CHANGES,
    payload: ICancelChangesPayload
}

export interface ICancelChangesSuccess extends Action {
    type: ActionTypes.CANCEL_CHANGES_SUCCESS
}

export interface ICancelChangesError extends Action {
    type: ActionTypes.CANCEL_CHANGES_ERROR,
    payload: IDetailsError
}

export interface IPressCancelChanges extends Action {
    type: ActionTypes.PRESS_CANCEL_CHANGES
}

export interface IDeclineCancelChanges extends Action {
    type: ActionTypes.DECLINE_CANCEL_CHANGES
}

export type IExamDataPayload =
    | FormData
    | ITestData
    | IDetailsError
    | IDownloadJSONPayload
    | IDownloadJSONSuccessPayload
    | IOpenCategoryPayload
    | IStartEditPayload
    | ISaveDraftPayload
    | ISendDraftForModerationPayload
    | IPublishExamPayload
    | IEditAnswerCorrectPayload
    | IEditQuestionTypePayload
    | IEditCategoryQuantityPayload
    | IEditSectionAllowedFailsPayload
    | IToggleRemoveAnswerPayload
    | IToggleRemoveQuestionPayload
    | IToggleRemoveCategoryPayload
    | IToggleRemoveSectionPayload
    | IChangeAnswerTextPayload
    | IChangeQuestionTextPayload
    | IAddAnswerPayload
    | IAddQuestionPayload
    | IAddCategoryPayload
    | IAddSectionPayload
    | ILoadFileSuccessPayload;

export type IExamDataAction =
    | ILoadFile
    | ILoadFileError
    | ILoadFileSuccess
    | IDownloadJSON
    | IDownloadJSONError
    | IDownloadJSONSuccess
    | IOpenCategory
    | ICloseCategory
    | IPublishExam
    | IPublishSuccess
    | IPublishFailed
    | IDeclinePublish
    | IPressPublish
    | IDeleteDraft
    | IDeleteDraftSuccess
    | IDeleteDraftError
    | IPressDeleteDraft
    | IDeclineDeleteDraft
    | IStartEdit
    | IStartEditSuccess
    | IStartEditError
    | ISaveDraft
    | ISaveDraftSuccess
    | ISaveDraftError
    | ISendDraftForModeration
    | ISendDraftForModerationSuccess
    | ISendDraftForModerationError
    | IEditAnswerCorrect
    | IEditQuestionType
    | IEditCategoryQuantity
    | IEditSectionAllowedFails
    | IToggleRemoveAnswer
    | IToggleRemoveQuestion
    | IToggleRemoveCategory
    | IToggleRemoveSection
    | IChangeAnswerText
    | IChangeQuestionText
    | IAddAnswer
    | IAddQuestion
    | IAddCategory
    | IAddSection
    | ICancelChanges
    | ICancelChangesSuccess
    | ICancelChangesError
    | IPressCancelChanges
    | IDeclineCancelChanges;
