import {
    ActionTypes,
    IFreeze,
    IUnfreeze,
    IFreezeSuccess,
    IUnfreezeSuccess,
    IFreezeError,
    IUnfreezeError,
    IChooseForFreeze,
    IChooseForUnfreeze
} from './types';

export function freeze(exams: number[]): IFreeze {
    return { type: ActionTypes.FREEZE, payload: { exams } };
}

export function unfreeze(exams: number[]): IUnfreeze {
    return { type: ActionTypes.UNFREEZE, payload: { exams } };
}

export function freezeSuccess(exams: number[], lastAttemptFinish: string): IFreezeSuccess {
    return { type: ActionTypes.FREEZE_SUCCESS, payload: { exams, lastAttemptFinish } };
}

export function unfreezeSuccess(exams: number[]): IUnfreezeSuccess {
    return { type: ActionTypes.UNFREEZE_SUCCESS, payload: { exams } };
}

export function setFreezeError(): IFreezeError {
    return { type: ActionTypes.FREEZE_ERROR };
}

export function setUnfreezeError(): IUnfreezeError {
    return { type: ActionTypes.UNFREEZE_ERROR };
}

export function chooseForFreeze(exams: number[]): IChooseForFreeze {
    return { type: ActionTypes.CHOOSE_FOR_FREEZE, payload: { exams } };
}

export function chooseForUnfreeze(exams: number[]): IChooseForUnfreeze {
    return { type: ActionTypes.CHOOSE_FOR_UNFREEZE, payload: { exams } };
}
